<?php
if (!defined('ABSPATH')) {
    exit;
}

class Logs_Handler {
    private $main_instance;

    public function __construct($main_instance) {
        $this->main_instance = $main_instance;
    }

    public function render_page() {
        // 从 Options 读取日志（与 class-bulk-content-manager.php 的 log_operation 一致）
        $all_logs = get_option('bcm_operation_logs', []);
        // 日志按时间倒序（最新在前）
        $logs = array_reverse($all_logs);

        echo '<div class="wrap">';
        echo '<h2>' . esc_html($this->main_instance->__ ('操作日志', 'Operation Logs')) . '</h2>';

        // ❌ 移除“清空日志”按钮（不允许清空）

        if (empty($logs)) {
            echo '<p>' . esc_html($this->main_instance->__ ('暂无操作日志。', 'No logs found.')) . '</p>';
        } else {
            echo '<table class="wp-list-table widefat fixed striped posts">';
            echo '<thead><tr>';
            echo '<th>' . esc_html($this->main_instance->__ ('时间', 'Time')) . '</th>';
            echo '<th>' . esc_html($this->main_instance->__ ('操作类型', 'Operation')) . '</th>';
            echo '<th>' . esc_html($this->main_instance->__ ('详情', 'Details')) . '</th>';
            echo '<th>' . esc_html($this->main_instance->__ ('操作人', 'Operator')) . '</th>'; // ✅ 新增列
            echo '<th>' . esc_html($this->main_instance->__ ('状态', 'Status')) . '</th>';
            echo '<th>' . esc_html($this->main_instance->__ ('耗时 (秒)', 'Duration (s)')) . '</th>';
            echo '</tr></thead>';
            echo '<tbody>';

            foreach ($logs as $log) {
                // 安全获取字段，防止未定义索引
                $timestamp = isset($log['timestamp']) ? (int)$log['timestamp'] : 0;
                $action = isset($log['action']) ? sanitize_text_field($log['action']) : '—';
                $details = isset($log['details']) ? sanitize_text_field($log['details']) : '—';
                $success = isset($log['success']) ? (bool)$log['success'] : false;
                $status = isset($log['status']) ? sanitize_text_field($log['status']) : ($success ? '成功' : '失败');
                $duration = isset($log['duration']) ? (float)$log['duration'] : 0.0;
                $operator = isset($log['operator']) ? sanitize_text_field($log['operator']) : 'system'; // ✅

                echo '<tr>';
                echo '<td>' . esc_html($timestamp ? date('Y-m-d H:i:s', $timestamp + (get_option('gmt_offset') * HOUR_IN_SECONDS)) : '—') . '</td>';
                echo '<td>' . esc_html($action) . '</td>';
                echo '<td>' . esc_html($details) . '</td>';
                echo '<td><code>' . esc_html($operator) . '</code></td>'; // ✅ 显示操作人
                echo '<td>' . ($success ? '✅ ' : '❌ ') . esc_html($status) . '</td>';
                echo '<td>' . number_format($duration, 3) . '</td>';
                echo '</tr>';
            }
            echo '</tbody></table>';
        }
        echo '</div>'; // .wrap
    }

    // ❌ 移除 handle_clear_logs 方法（不再需要）
}