<?php
/**
 * Plugin Name: 批量内容管理器 / Bulk Content Manager
 * Description: 批量管理分类、文章标题与标签。支持导出/导入、筛选、图片统计、带状态的操作记录。
 * Version: 2.6.0
 * Author: limaomao810.com
 * License: GPLv2 or later
 */

if (!defined('ABSPATH')) {
    exit;
}

// 定义插件根目录常量
if (!defined('BCM_PLUGIN_DIR')) {
    define('BCM_PLUGIN_DIR', plugin_dir_path(__FILE__));
}

// 加载公共函数
require_once BCM_PLUGIN_DIR . 'includes/functions.php';

// 加载核心类
require_once BCM_PLUGIN_DIR . 'includes/class-bulk-content-manager.php';
require_once BCM_PLUGIN_DIR . 'includes/class-posts-handler.php';
require_once BCM_PLUGIN_DIR . 'includes/class-categories-handler.php';
require_once BCM_PLUGIN_DIR . 'includes/class-tags-handler.php';
require_once BCM_PLUGIN_DIR . 'includes/class-logs-handler.php';
require_once BCM_PLUGIN_DIR . 'includes/class-transfer-handler.php';

// 初始化插件
new Bulk_Content_Manager();