(function($) {
    'use strict';

    // ================== 分类：快速编辑 ==================
    $(document).on('click', '.edit-category', function(e) {
        e.preventDefault();
        var id = $(this).data('id');

        // 加载分类完整数据
        $.post(bcm_ajax.ajax_url, {
            action: 'bcm_get_category_full',
            id: id
        }, function(response) {
            if (response.success && response.data) {
                var cat = response.data;
                $('#edit-cat-id').val(cat.term_id);
                $('#edit-cat-name').val(cat.name || '');
                $('#edit-cat-slug').val(cat.slug || '');
                $('#edit-cat-description').val(cat.description || '');

                // 加载父级下拉（排除自身）
                $('#edit-cat-parent').empty().append('<option value="0">— 无父级 —</option>');
                $.post(bcm_ajax.ajax_url, {
                    action: 'bcm_get_all_categories_for_select',
                    exclude: id
                }, function(cats) {
                    if (cats.success && Array.isArray(cats.data)) {
                        cats.data.forEach(function(c) {
                            var opt = $('<option>').val(c.term_id).text(c.name);
                            if (parseInt(c.term_id) === parseInt(cat.parent)) {
                                opt.prop('selected', true);
                            }
                            $('#edit-cat-parent').append(opt);
                        });
                    }
                });

                $('#edit-category-modal').show();
            } else {
                alert('加载分类信息失败，请重试。');
            }
        });
    });

    // 保存快速编辑
    $(document).on('submit', '#edit-category-form', function(e) {
        e.preventDefault();
        var id = $('#edit-cat-id').val();
        var name = $('#edit-cat-name').val().trim();
        if (!id || !name) return;

        $.post(bcm_ajax.ajax_url, {
            action: 'bcm_update_category_full',
            id: id,
            name: name,
            slug: $('#edit-cat-slug').val().trim(),
            parent: $('#edit-cat-parent').val(),
            description: $('#edit-cat-description').val().trim()
        }, function(response) {
            if (response.success) {
                location.reload(); // 简单刷新
            } else {
                alert('保存失败：' + (response.data?.message || '未知错误'));
            }
        });
    });

    // ================== 文章：快速编辑标题 ==================
    $(document).on('click', '.edit-post-title', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        var current = $(this).closest('tr').find('.column-title strong').text();
        var newTitle = prompt('请输入新标题：', current);
        if (newTitle && newTitle !== current) {
            $.post(bcm_ajax.ajax_url, {
                action: 'bcm_update_title',
                id: id,
                title: newTitle
            }, function() {
                location.reload();
            });
        }
    });

    // ================== 标签：快速编辑 ==================
    $(document).on('click', '.edit-tag', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        var current = $(this).closest('tr').find('.column-name').text();
        var newName = prompt('请输入新标签名：', current);
        if (newName && newName !== current) {
            $.post(bcm_ajax.ajax_url, {
                action: 'bcm_update_tag',
                id: id,
                name: newName
            }, function() {
                location.reload();
            });
        }
    });

})(jQuery);